﻿' 模板规则
'   1. 用 "'<snippet>" 标记来标记代码段。第一处标记用于确定代码段的开头。
'      第二处标记用于确定结尾。建议(但不要求)添加 BEGIN 和
'      END 后缀，以便获得更佳的可读性，例如 "'<snippet> - BEGIN"，"'<snippet> - END"。
'      如果代码段只有一行，则可以省略第二个标记(例如，请参阅 ClrNamespaceFooter 标记)。
'
'   2. 代码段标记应该位于代码段上面(下面)单独的行上，或者位于第一个 
'      (最后一个)代码段行的末尾。从标记到行末尾的文本将被删除。
'
'   3. 以下区分大小写的字是保留字。它们将在示例数据代码生成过程中被数据存储名称(类型名称、
'      属性名称等)所替代。
'          CLR_NAMESPACE
'          GLOBALSTORAGE_TYPE
'          DATASTORE_TYPE
'          PROPERTY_NAME
'          PROPERTY_TYPE
'          PROPERTY_VALUE
'          PROJECT_ASSEMBLY_NAME
'          DATA_STORE_ROOT_FOLDER
'          DATA_STORE_NAME
'
'   4. 区分大小写的代码段标记为
'          ClrNamespaceHeader
'          ClrNamespaceFooter
'          GlobalStorageTypeHeader
'          GlobalStorageTypeFooter
'          GlobalStorageGetSetProperty
'          DataStoreTypeHeader
'          DataStoreTypeFooter
'          DataStoreTypeConstructor
'          DataStoreGetSetProperty
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Imports System  'ClrNamespaceHeader - BEGIN
Imports System.Collections.Generic
Namespace CLR_NAMESPACE 'ClrNamespaceHeader - END
	Public Class GLOBALSTORAGE_TYPE  'GlobalStorageTypeHeader - BEGIN
		Public Shared Singleton As GLOBALSTORAGE_TYPE
		Private _registrar As List(Of WeakReference)
		Private _loading As Boolean

		
		Public Property Loading As Boolean
		Get
			Return Me._loading
		End Get
		Set(ByVal value As Boolean)
				Me._loading = value
		End Set
		End Property
		
		Shared Sub New()
			GLOBALSTORAGE_TYPE.Singleton = New GLOBALSTORAGE_TYPE
		End Sub
		
		Public Sub New()
			Me._registrar = New List(Of WeakReference)
		End Sub

		Public Sub Register(ByVal dataStore As DATASTORE_TYPE)
			Me._registrar.Add(new WeakReference(dataStore))
		End Sub
		
		Public Sub OnPropertyChanged(ByVal propertyName As String)
			Dim entry As WeakReference
			For Each entry In Me._registrar
				If entry.IsAlive Then
					DirectCast(entry.Target, DATASTORE_TYPE).FirePropertyChanged(propertyName)
				End If
			Next
		End Sub
				
		Public ReadOnly Property AssignementAllowed As Boolean
			Get
				If (Me.Loading AndAlso (Me._registrar.Count > 0)) Then
					Return False
				End If
				Return True
			End Get
		End Property 

		'在下面列出属性 
		'GlobalStorageTypeHeader - END
		Private _PROPERTY_NAME As PROPERTY_TYPE = PROPERTY_VALUE 'GlobalStorageGetSetProperty - BEGIN
		Public Property PROPERTY_NAME() As PROPERTY_TYPE
			Get
				Return Me._PROPERTY_NAME
			End Get

			Set(ByVal value As PROPERTY_TYPE)
				If (Me.AssignementAllowed AndAlso (Me._PROPERTY_NAME <> value)) Then
					Me._PROPERTY_NAME = value
					Me.OnPropertyChanged("PROPERTY_NAME")
				End If
			End Set
		End Property 'GlobalStorageGetSetProperty - END
	End Class 'GlobalStorageTypeFooter
	
	Public Class DATASTORE_TYPE  'DataStoreTypeHeader - BEGIN
		Implements System.ComponentModel.INotifyPropertyChanged

		Public Event PropertyChanged As System.ComponentModel.PropertyChangedEventHandler Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged
		
		Public Sub FirePropertyChanged(ByVal propertyName As String)
			Me.OnPropertyChanged(propertyName)
		End Sub
		
		Protected Overridable Sub OnPropertyChanged(ByVal propertyName As String)
			Dim handler As System.ComponentModel.PropertyChangedEventHandler = Me.PropertyChangedEvent
			If handler IsNot Nothing Then
				RaiseEvent PropertyChanged(Me, New System.ComponentModel.PropertyChangedEventArgs(propertyName))
			End If
		End Sub 'DataStoreTypeHeader - END

		Public Sub New() 'DataStoreTypeConstructor - BEGIN
			MyBase.New()
			Try
				Dim resourceUri As System.Uri = New System.Uri("/PROJECT_ASSEMBLY_NAME;component/DATA_STORE_ROOT_FOLDER/DATA_STORE_NAME/DATA_STORE_NAME.xaml", System.UriKind.Relative)
				If System.Windows.Application.GetResourceStream(resourceUri) IsNot Nothing Then
					GLOBALSTORAGE_TYPE.Singleton.Loading = True
					System.Windows.Application.LoadComponent(Me, resourceUri)
					GLOBALSTORAGE_TYPE.Singleton.Loading = False
					GLOBALSTORAGE_TYPE.Singleton.Register(Me)
				End If
			Catch __exception As System.Exception
			End Try
		End Sub 'DataStoreTypeConstructor - END

		Private _PROPERTY_NAME As PROPERTY_TYPE = PROPERTY_VALUE 'DataStoreGetSetProperty - BEGIN
		Public Property PROPERTY_NAME() As PROPERTY_TYPE
			Get
				 Return GLOBALSTORAGE_TYPE.Singleton.PROPERTY_NAME
			End Get

			Set(ByVal value As PROPERTY_TYPE)
				GLOBALSTORAGE_TYPE.Singleton.PROPERTY_NAME = value
			End Set
		End Property 'DataStoreGetSetProperty - END

	End Class 'DataStoreTypeFooter
End Namespace 'ClrNamespaceFooter